<?php

namespace App/Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password');

	public function posts()
	{
		return $this->belongsToMany('App/Models\Post');
	}

	public function student_registration()
	{
		return $this->hasOne('App/Models\Student_registration');
	}

	public function testimonials()
	{
		return $this->hasMany('App/Models\Testimonials');
	}

	public function subjects()
	{
		return $this->hasMany('App/Models\Subjects');
	}

}