<?php

namespace App\Models;

class Clients extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	public function client_phones()
	{
		return $this->hasMany('App\Models\Phones');
	}

	public function client_addresses()
	{
		return $this->hasMany('App\Models\Address');
	}

	public function client_email()
	{
		return $this->hasMany('App\Models\Email');
	}

	public function created_by()
	{
		return $this->hasOne('App\Models\Users', 'id', 'created_by');
	}

	public function projects()
	{
		return $this->hasMany('App\Models\Projets');
	}

}