<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Accounts()
	{
		return $this->hasMany('App\Account', 'user_id');
	}

	public function Transfers()
	{
		return $this->hasMany('App\Transfer', 'user_id');
	}

	public function Area()
	{
		return $this->belongsTo('App\Area', 'area_id');
	}

}