<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Accounts()
    {
        return $this->hasMany('App\Account', 'user_id');
    }

    public function Transfers()
    {
        return $this->hasMany('App\Transfer', 'user_id');
    }

    public function Area()
    {
        return $this->belongsTo('App\Area', 'area_id');
    }

}