<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('platform_id')->references('id')->on('platforms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('acc_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('pack_id')->references('id')->on('packs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_user_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_platform_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_area_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_bank_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_acc_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_pack_id_foreign');
		});
	}
}