<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('doctor_chambers', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctor_chambers', function(Blueprint $table) {
			$table->foreign('chamber_id')->references('id')->on('chambers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctor_subscriptions', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctor_subscriptions', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctor_subscriptions', function(Blueprint $table) {
			$table->foreign('subscription_package_id')->references('id')->on('subscription_packages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('drugs_doses', function(Blueprint $table) {
			$table->foreign('drug_id')->references('id')->on('drugs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('drugs_doses', function(Blueprint $table) {
			$table->foreign('dose_id')->references('id')->on('doses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('durgs_categories', function(Blueprint $table) {
			$table->foreign('categories_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('doctor_chamber_id')->references('id')->on('doctor_chambers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_fitness', function(Blueprint $table) {
			$table->foreign('fitness_id')->references('id')->on('fitness')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_fitness', function(Blueprint $table) {
			$table->foreign('prescription_id')->references('id')->on('prescriptions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_complaints', function(Blueprint $table) {
			$table->foreign('prescription_id')->references('id')->on('prescriptions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_complaints', function(Blueprint $table) {
			$table->foreign('complaint_id')->references('id')->on('complaints')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_inspections', function(Blueprint $table) {
			$table->foreign('inspection_id')->references('id')->on('inspections')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_patient_symptoms', function(Blueprint $table) {
			$table->foreign('patient_symptom_id')->references('id')->on('patient_symptoms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_investigations', function(Blueprint $table) {
			$table->foreign('investigation_id')->references('id')->on('investigations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_advices', function(Blueprint $table) {
			$table->foreign('advice_id')->references('id')->on('advices')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->foreign('drug_id')->references('id')->on('drugs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->foreign('dose_id')->references('id')->on('doses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('schedules')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->foreign('duration_id')->references('id')->on('durations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->foreign('dosage_id')->references('id')->on('dosages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patients_notes', function(Blueprint $table) {
			$table->foreign('doctor_chamber_id')->references('id')->on('doctor_chambers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patients_notes', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patients_notes', function(Blueprint $table) {
			$table->foreign('note_id')->references('id')->on('notes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('doctor_chambers', function(Blueprint $table) {
			$table->dropForeign('doctor_chambers_doctor_id_foreign');
		});
		Schema::table('doctor_chambers', function(Blueprint $table) {
			$table->dropForeign('doctor_chambers_chamber_id_foreign');
		});
		Schema::table('doctor_subscriptions', function(Blueprint $table) {
			$table->dropForeign('doctor_subscriptions_doctor_id_foreign');
		});
		Schema::table('doctor_subscriptions', function(Blueprint $table) {
			$table->dropForeign('doctor_subscriptions_payment_method_id_foreign');
		});
		Schema::table('doctor_subscriptions', function(Blueprint $table) {
			$table->dropForeign('doctor_subscriptions_subscription_package_id_foreign');
		});
		Schema::table('drugs_doses', function(Blueprint $table) {
			$table->dropForeign('drugs_doses_drug_id_foreign');
		});
		Schema::table('drugs_doses', function(Blueprint $table) {
			$table->dropForeign('drugs_doses_dose_id_foreign');
		});
		Schema::table('durgs_categories', function(Blueprint $table) {
			$table->dropForeign('durgs_categories_categories_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_doctor_chamber_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_patient_id_foreign');
		});
		Schema::table('prescriptions_fitness', function(Blueprint $table) {
			$table->dropForeign('prescriptions_fitness_fitness_id_foreign');
		});
		Schema::table('prescriptions_fitness', function(Blueprint $table) {
			$table->dropForeign('prescriptions_fitness_prescription_id_foreign');
		});
		Schema::table('prescriptions_complaints', function(Blueprint $table) {
			$table->dropForeign('prescriptions_complaints_prescription_id_foreign');
		});
		Schema::table('prescriptions_complaints', function(Blueprint $table) {
			$table->dropForeign('prescriptions_complaints_complaint_id_foreign');
		});
		Schema::table('prescriptions_inspections', function(Blueprint $table) {
			$table->dropForeign('prescriptions_inspections_inspection_id_foreign');
		});
		Schema::table('prescriptions_patient_symptoms', function(Blueprint $table) {
			$table->dropForeign('prescriptions_patient_symptoms_patient_symptom_id_foreign');
		});
		Schema::table('prescriptions_investigations', function(Blueprint $table) {
			$table->dropForeign('prescriptions_investigations_investigation_id_foreign');
		});
		Schema::table('prescriptions_advices', function(Blueprint $table) {
			$table->dropForeign('prescriptions_advices_advice_id_foreign');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->dropForeign('prescriptions_details_category_id_foreign');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->dropForeign('prescriptions_details_drug_id_foreign');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->dropForeign('prescriptions_details_dose_id_foreign');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->dropForeign('prescriptions_details_schedule_id_foreign');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->dropForeign('prescriptions_details_duration_id_foreign');
		});
		Schema::table('prescriptions_details', function(Blueprint $table) {
			$table->dropForeign('prescriptions_details_dosage_id_foreign');
		});
		Schema::table('patients_notes', function(Blueprint $table) {
			$table->dropForeign('patients_notes_doctor_chamber_id_foreign');
		});
		Schema::table('patients_notes', function(Blueprint $table) {
			$table->dropForeign('patients_notes_patient_id_foreign');
		});
		Schema::table('patients_notes', function(Blueprint $table) {
			$table->dropForeign('patients_notes_note_id_foreign');
		});
	}
}