<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name', 64);
			$table->string('username', 32)->unique();
			$table->string('password', 80);
			$table->string('gender')->nullable();
			$table->string('email', 64)->unique();
			$table->string('phone_number', 16)->unique();
			$table->string('qualification')->nullable();
			$table->string('speciality')->nullable();
			$table->string('city', 64)->default('Dhaka');
			$table->string('zip_code', 32)->nullable();
			$table->string('country', 32)->default('Bangladesh');
			$table->string('identification_number', 64)->nullable();
			$table->string('professional_id_number', 64)->nullable();
			$table->text('bio')->nullable();
			$table->string('avatar', 60)->nullable();
			$table->string('status', 64);
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->rememberToken();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}