<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customer_data', function(Blueprint $table) {
			$table->foreign('customer_data_has_marchant_id')->references('id')->on('customer_has_merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_data', function(Blueprint $table) {
			$table->foreign('customer_data_type_id')->references('id')->on('customer_data_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customer_social_login_data', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_has_merchants', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_has_merchants', function(Blueprint $table) {
			$table->foreign('marchant_id')->references('id')->on('merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customerMarchant_has_providerMarchant', function(Blueprint $table) {
			$table->foreign('customer_has_marchant_id')->references('id')->on('customer_has_merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customerMarchant_has_providerMarchant', function(Blueprint $table) {
			$table->foreign('provider_has_marchant_id')->references('id')->on('marchants_has_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('policies', function(Blueprint $table) {
			$table->foreign('customer_has_marchant_id')->references('id')->on('customer_has_merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('policies', function(Blueprint $table) {
			$table->foreign('marchant_id')->references('id')->on('merchants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customer_data', function(Blueprint $table) {
			$table->dropForeign('customer_data_customer_data_has_marchant_id_foreign');
		});
		Schema::table('customer_data', function(Blueprint $table) {
			$table->dropForeign('customer_data_customer_data_type_id_foreign');
		});
		Schema::table('customer_social_login_data', function(Blueprint $table) {
			$table->dropForeign('customer_social_login_data_user_id_foreign');
		});
		Schema::table('customer_has_merchants', function(Blueprint $table) {
			$table->dropForeign('customer_has_merchants_customer_id_foreign');
		});
		Schema::table('customer_has_merchants', function(Blueprint $table) {
			$table->dropForeign('customer_has_merchants_marchant_id_foreign');
		});
		Schema::table('customerMarchant_has_providerMarchant', function(Blueprint $table) {
			$table->dropForeign('customerMarchant_has_providerMarchant_customer_has_marchant_id_foreign');
		});
		Schema::table('customerMarchant_has_providerMarchant', function(Blueprint $table) {
			$table->dropForeign('customerMarchant_has_providerMarchant_provider_has_marchant_id_foreign');
		});
		Schema::table('policies', function(Blueprint $table) {
			$table->dropForeign('policies_customer_has_marchant_id_foreign');
		});
		Schema::table('policies', function(Blueprint $table) {
			$table->dropForeign('policies_marchant_id_foreign');
		});
	}
}