<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMsgserverTable extends Migration {

	public function up()
	{
		Schema::create('msgserver', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('module_id')->index();
			$table->string('code', 255)->index();
			$table->bigInteger('domain_id')->unsigned()->index();
			$table->string('type', 255)->index();
			$table->bigInteger('country_id')->index();
			$table->bigInteger('lang_id')->unsigned()->index();
			$table->bigInteger('server_id')->index();
			$table->string('name', 255)->index();
		});
	}

	public function down()
	{
		Schema::drop('msgserver');
	}
}