<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('dossier', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->foreign('nature_affaire_id')->references('id')->on('nature_affaire')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->foreign('pays_id')->references('id')->on('pays')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->foreign('redacteur_id')->references('id')->on('redacteur')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->foreign('magistrat_id')->references('id')->on('magistrat')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->foreign('mandataire_id')->references('id')->on('mandataire')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('diligence', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('diligence')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('magistrat', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('requerant')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('redacteur', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->foreign('dossier_id')->references('id')->on('dossier')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->foreign('diligence_id')->references('id')->on('diligence')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->foreign('magistrat_id')->references('id')->on('magistrat')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->foreign('redacteur_id')->references('id')->on('redacteur')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier_requerant', function(Blueprint $table) {
			$table->foreign('dossier_id')->references('id')->on('dossier')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('dossier_requerant', function(Blueprint $table) {
			$table->foreign('requerant_id')->references('id')->on('requerant')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('dossier', function(Blueprint $table) {
			$table->dropForeign('dossier_service_id_foreign');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->dropForeign('dossier_nature_affaire_id_foreign');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->dropForeign('dossier_pays_id_foreign');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->dropForeign('dossier_redacteur_id_foreign');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->dropForeign('dossier_magistrat_id_foreign');
		});
		Schema::table('dossier', function(Blueprint $table) {
			$table->dropForeign('dossier_mandataire_id_foreign');
		});
		Schema::table('diligence', function(Blueprint $table) {
			$table->dropForeign('diligence_service_id_foreign');
		});
		Schema::table('magistrat', function(Blueprint $table) {
			$table->dropForeign('magistrat_service_id_foreign');
		});
		Schema::table('redacteur', function(Blueprint $table) {
			$table->dropForeign('redacteur_service_id_foreign');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->dropForeign('dossier_diligence_dossier_id_foreign');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->dropForeign('dossier_diligence_diligence_id_foreign');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->dropForeign('dossier_diligence_magistrat_id_foreign');
		});
		Schema::table('dossier_diligence', function(Blueprint $table) {
			$table->dropForeign('dossier_diligence_redacteur_id_foreign');
		});
		Schema::table('dossier_requerant', function(Blueprint $table) {
			$table->dropForeign('dossier_requerant_dossier_id_foreign');
		});
		Schema::table('dossier_requerant', function(Blueprint $table) {
			$table->dropForeign('dossier_requerant_requerant_id_foreign');
		});
	}
}