<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientInstallmentsTable extends Migration {

	public function up()
	{
		Schema::create('client_installments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->unsigned();
			$table->integer('fund_id')->unsigned();
			$table->integer('revise_no');
			$table->string('install_amount', 50);
			$table->integer('status');
			$table->date('due_date');
			$table->date('pay_date');
			$table->integer('provider_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('client_installments');
	}
}