<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderReceiversTable extends Migration {

	public function up()
	{
		Schema::create('order_receivers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned();
			$table->string('reason')->nullable();
			$table->string('signature')->nullable();
			$table->string('image')->nullable();
			$table->string('status');
			$table->string('receiver')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_receivers');
	}
}