<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->bigInteger('creator_user_id');
			$table->integer('status_id');
			$table->integer('order_type_id');
			$table->integer('operation_status_id');
			$table->integer('cargo_firm_integration_id')->nullable();
			$table->string('special_unique_id')->unique();
			$table->integer('company_warehouse_id');
			$table->string('uuid')->unique();
			$table->string('name');
			$table->smallInteger('status');
			$table->string('tracking_number')->nullable();
			$table->string('special_tracking_number')->nullable();
			$table->smallInteger('items_count')->nullable();
			$table->string('source')->nullable();
			$table->decimal('payment_price');
			$table->string('payment_type');
			$table->decimal('order_price')->nullable();
			$table->string('reference_number');
			$table->string('reference_number2')->nullable();
			$table->string('reference_number3')->nullable();
			$table->string('order_price_3rd')->nullable();
			$table->timestamp('last_moving_at')->nullable();
			$table->timestamp('first_estimated_at');
			$table->timestamp('second_estimated_at')->nullable();
			$table->timestamp('cargo_created_at')->nullable();
			$table->timestamp('completed_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}