<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCargoFirmIntegrationTokensTable extends Migration {

	public function up()
	{
		Schema::create('cargo_firm_integration_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('cargo_firm_integration_id');
			$table->text('token');
			$table->text('refresh_token')->nullable();
			$table->tinyInteger('status');
			$table->string('resolver');
			$table->text('response');
			$table->timestamp('expired_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cargo_firm_integration_tokens');
	}
}