<?php

namespace App\Models\Cargo;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class IntegrationToken extends Eloquent {

	protected $table = 'cargo_firm_integration_tokens';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('refresh_token', 'status', 'resolver', 'expired_at');
	protected $visible = array('status', 'resolver');

	public function cargoFirm()
	{
		return $this->belongsTo('App\Models\Cargo\Firm');
	}

}