<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Log extends Eloquent {

	protected $table = 'order_logs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('priority');
	protected $visible = array('priority');

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

}