<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TicketPriority extends Eloquent {

	protected $table = 'ticket_priorities';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'color');
	protected $visible = array('name', 'description', 'color');

	public function tickets()
	{
		return $this->hasMany('Ticket');
	}

}