<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('account_name', 254);
			$table->date('dob');
			$table->string('fullname', 254);
			$table->string('mobile', 30);
			$table->string('email', 254);
			$table->string('vcode', 30);
			$table->text('password');
			$table->string('avatar', 254);
			$table->string('region', 30);
			$table->string('city', 30);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}