<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliatesTable extends Migration {

	public function up()
	{
		Schema::create('affiliates', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('code')->unique();
			$table->boolean('is_active')->default(false);
			$table->string('payment_email');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('affiliates');
	}
}