<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartenairesTable extends Migration {

	public function up()
	{
		Schema::create('partenaires', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('denomination', 50);
			$table->string('adresse', 255);
			$table->string('complement_adresse', 255);
			$table->string('code_postal', 5);
			$table->string('ville', 255);
			$table->string('telephone_fixe', 10);
			$table->string('telephone_portable', 10);
			$table->string('email', 255);
			$table->string('site_internet', 255);
			$table->string('prenom_contact', 255);
			$table->string('nom_contact', 255);
			$table->string('fonction_contact', 255);
			$table->string('forme_juridique', 10);
			$table->mediumInteger('capital')->unsigned();
			$table->string('siret', 14);
			$table->string('siren', 9);
			$table->string('rcs', 255);
			$table->string('naf_ape', 5);
			$table->string('infos', 255);
		});
	}

	public function down()
	{
		Schema::drop('partenaires');
	}
}