<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjetsTable extends Migration {

	public function up()
	{
		Schema::create('projets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('denomination_courte', 6);
			$table->string('denomination', 255);
			$table->date('date_demarrage');
			$table->boolean('is_termine');
			$table->string('couleur', 11);
			$table->string('adresse', 255);
			$table->string('complement_adresse', 255);
			$table->string('code_postal', 5);
			$table->string('ville', 255);
			$table->text('infos');
			$table->integer('client_id')->unsigned();
			$table->integer('type_projet_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('projets');
	}
}