<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('collaborateurs', function(Blueprint $table) {
			$table->foreign('type_collaborateur_id')->references('id')->on('type_collaborateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('type_client_id')->references('id')->on('type_clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->foreign('type_projet_id')->references('id')->on('type_projets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('phases', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('phases', function(Blueprint $table) {
			$table->foreign('type_phase_id')->references('id')->on('type_phases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->foreign('phase_id')->references('id')->on('phases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factures', function(Blueprint $table) {
			$table->foreign('phase_id')->references('id')->on('phases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evenements', function(Blueprint $table) {
			$table->foreign('collaborateur_id')->references('id')->on('collaborateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evenements', function(Blueprint $table) {
			$table->foreign('phase_id')->references('id')->on('phases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('partenaire_projet', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('partenaire_projet', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deplacements', function(Blueprint $table) {
			$table->foreign('collaborateur_id')->references('id')->on('collaborateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('collaborateur_id')->references('id')->on('collaborateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicules', function(Blueprint $table) {
			$table->foreign('collaborateur_id')->references('id')->on('collaborateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->foreign('phase_id')->references('id')->on('phases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evenement_prospections', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evenement_prospection_type_prospection', function(Blueprint $table) {
			$table->foreign('evenement_prospection_id')->references('id')->on('evenement_prospections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('evenement_prospection_type_prospection', function(Blueprint $table) {
			$table->foreign('type_prospection_id')->references('id')->on('type_prospections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('candidatures', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('candidatures', function(Blueprint $table) {
			$table->foreign('collaborateur_id')->references('id')->on('collaborateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('candidature_partenaire', function(Blueprint $table) {
			$table->foreign('candidature_id')->references('id')->on('candidatures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('candidature_partenaire', function(Blueprint $table) {
			$table->foreign('partenaire_id')->references('id')->on('partenaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('collaborateurs', function(Blueprint $table) {
			$table->dropForeign('collaborateurs_type_collaborateur_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_type_client_id_foreign');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->dropForeign('projets_client_id_foreign');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->dropForeign('projets_type_projet_id_foreign');
		});
		Schema::table('phases', function(Blueprint $table) {
			$table->dropForeign('phases_projet_id_foreign');
		});
		Schema::table('phases', function(Blueprint $table) {
			$table->dropForeign('phases_type_phase_id_foreign');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->dropForeign('missions_partenaire_id_foreign');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->dropForeign('missions_phase_id_foreign');
		});
		Schema::table('factures', function(Blueprint $table) {
			$table->dropForeign('factures_phase_id_foreign');
		});
		Schema::table('evenements', function(Blueprint $table) {
			$table->dropForeign('evenements_collaborateur_id_foreign');
		});
		Schema::table('evenements', function(Blueprint $table) {
			$table->dropForeign('evenements_phase_id_foreign');
		});
		Schema::table('partenaire_projet', function(Blueprint $table) {
			$table->dropForeign('partenaire_projet_partenaire_id_foreign');
		});
		Schema::table('partenaire_projet', function(Blueprint $table) {
			$table->dropForeign('partenaire_projet_projet_id_foreign');
		});
		Schema::table('deplacements', function(Blueprint $table) {
			$table->dropForeign('deplacements_collaborateur_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_collaborateur_id_foreign');
		});
		Schema::table('vehicules', function(Blueprint $table) {
			$table->dropForeign('vehicules_collaborateur_id_foreign');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->dropForeign('taches_phase_id_foreign');
		});
		Schema::table('evenement_prospections', function(Blueprint $table) {
			$table->dropForeign('evenement_prospections_client_id_foreign');
		});
		Schema::table('evenement_prospection_type_prospection', function(Blueprint $table) {
			$table->dropForeign('evenement_prospection_type_prospection_evenement_prospection_id_foreign');
		});
		Schema::table('evenement_prospection_type_prospection', function(Blueprint $table) {
			$table->dropForeign('evenement_prospection_type_prospection_type_prospection_id_foreign');
		});
		Schema::table('candidatures', function(Blueprint $table) {
			$table->dropForeign('candidatures_client_id_foreign');
		});
		Schema::table('candidatures', function(Blueprint $table) {
			$table->dropForeign('candidatures_collaborateur_id_foreign');
		});
		Schema::table('candidature_partenaire', function(Blueprint $table) {
			$table->dropForeign('candidature_partenaire_candidature_id_foreign');
		});
		Schema::table('candidature_partenaire', function(Blueprint $table) {
			$table->dropForeign('candidature_partenaire_partenaire_id_foreign');
		});
	}
}