<?php

namespace App;

class Candidature extends Eloquent {

	protected $table = 'candidatures';
	public $timestamps = true;
	protected $fillable = array('lieu', 'distance', 'date_publication', 'date_reponse', 'denomination', 'prenom_contact', 'nom_contact', 'telephone_contact', 'email_contact', 'montant_travaux', 'surface', 'prix_surface', 'infos', 'competences_attendues', 'reponse', 'is_offre', 'is_methodo', 'is_retenu', 'is_seconde_phase');

	public function partenaires()
	{
		return $this->belongsToMany('App\Partenaire');
	}

	public function collaborateur()
	{
		return $this->belongsTo('App\Collaborateur');
	}

	public function client()
	{
		return $this->belongsTo('App\Client');
	}

}