<?php

namespace App;

class LSD_Tourlist extends Eloquent {

	protected $table = 'tourlists';
	public $timestamps = true;
	protected $fillable = array('title', 'author_id');

	public function tours()
	{
		return $this->hasMany('LSD_Tour')->with;
	}

	public function comments()
	{
		return $this->hasMany('LSD_Comment');
	}

	public function author()
	{
		return $this->belongsTo('LSD_User');
	}

	public function tags()
	{
		return $this->morphToMany('App\Tag', 'taggable');
	}

	public function favorors()
	{
		return $this->morphToMany('App\User', 'favoritable');
	}

}