<?php

namespace App;

class LSD_Tourstop extends Eloquent {

	protected $table = 'tourstops';
	public $timestamps = true;
	protected $fillable = array('title', 'city_id', 'state_id', 'zip', 'short_description', 'long_description', 'thumbnail_id', 'latitude', 'longitude', 'public');

	public function tour()
	{
		return $this->belongsToMany('LSD_Tour')->withPivot('order');
	}

	public function media()
	{
		return $this->hasMany('LSD_Mediaresource')->withPivot('order');
	}

	public function comments()
	{
		return $this->hasMany('LSD_Comment');
	}

	public function tags()
	{
		return $this->morphToMany('App\Tag', 'taggable');
	}

	public function favorors()
	{
		return $this->morphToMany('App\User', 'favoritable');
	}

}