<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTourstopsTable extends Migration {

	public function up()
	{
		Schema::create('tourstops', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 128);
			$table->integer('city_id')->unsigned()->nullable();
			$table->integer('state_id')->unsigned()->nullable();
			$table->string('zip', 12);
			$table->text('short_description');
			$table->text('long_description');
			$table->integer('thumbnail_id')->unsigned()->nullable();
			$table->decimal('latitude', 8,3);
			$table->decimal('longitude', 8,3);
			$table->tinyInteger('public')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('tourstops');
	}
}