<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_to_rally', function(Blueprint $table) {
			$table->foreign('rally_id')->references('id')->on('Rallies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_to_rally', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('user_to_rally', function(Blueprint $table) {
			$table->dropForeign('user_to_rally_rally_id_foreign');
		});
		Schema::table('user_to_rally', function(Blueprint $table) {
			$table->dropForeign('user_to_rally_user_id_foreign');
		});
	}
}