<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('equipment', function(Blueprint $table) {
			$table->foreign('id_masterEquipment_foreign_key')->references('id_masterEquipment')->on('masterEquipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipment', function(Blueprint $table) {
			$table->foreign('id_wirelessEquipment_foreign_key')->references('id_wirelessEquipment')->on('wirelessEquipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipment', function(Blueprint $table) {
			$table->foreign('id_module_foreign_key')->references('id_moduleEquipment')->on('moduleEquipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipment', function(Blueprint $table) {
			$table->foreign('id_slaveEquipment_foreign_key')->references('id_slaveEquipment')->on('slaveEquipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipmentLicense', function(Blueprint $table) {
			$table->foreign('id_equipment_foreign_key')->references('id_equipment')->on('equipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ovlicense', function(Blueprint $table) {
			$table->foreign('id_ov_foreign_key')->references('id_ov')->on('ov')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('masterEquipment', function(Blueprint $table) {
			$table->foreign('id_ov_foreign_key')->references('id_ov')->on('ov')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wirelessEquipment', function(Blueprint $table) {
			$table->foreign('id_ov_foreign_key')->references('id_ov')->on('ov')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('moduleEquipment', function(Blueprint $table) {
			$table->foreign('id_equipment_foreign_key')->references('id_equipment')->on('equipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('slaveEquipment', function(Blueprint $table) {
			$table->foreign('id_masterEquipment_foreign_key')->references('id_masterEquipment')->on('masterEquipment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('equipment', function(Blueprint $table) {
			$table->dropForeign('equipment_id_masterEquipment_foreign_key_foreign');
		});
		Schema::table('equipment', function(Blueprint $table) {
			$table->dropForeign('equipment_id_wirelessEquipment_foreign_key_foreign');
		});
		Schema::table('equipment', function(Blueprint $table) {
			$table->dropForeign('equipment_id_module_foreign_key_foreign');
		});
		Schema::table('equipment', function(Blueprint $table) {
			$table->dropForeign('equipment_id_slaveEquipment_foreign_key_foreign');
		});
		Schema::table('equipmentLicense', function(Blueprint $table) {
			$table->dropForeign('equipmentLicense_id_equipment_foreign_key_foreign');
		});
		Schema::table('ovlicense', function(Blueprint $table) {
			$table->dropForeign('ovlicense_id_ov_foreign_key_foreign');
		});
		Schema::table('masterEquipment', function(Blueprint $table) {
			$table->dropForeign('masterEquipment_id_ov_foreign_key_foreign');
		});
		Schema::table('wirelessEquipment', function(Blueprint $table) {
			$table->dropForeign('wirelessEquipment_id_ov_foreign_key_foreign');
		});
		Schema::table('moduleEquipment', function(Blueprint $table) {
			$table->dropForeign('moduleEquipment_id_equipment_foreign_key_foreign');
		});
		Schema::table('slaveEquipment', function(Blueprint $table) {
			$table->dropForeign('slaveEquipment_id_masterEquipment_foreign_key_foreign');
		});
	}
}