<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_no')->unique()->unsigned();
			$table->bigInteger('mvikas_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('payment_term_id')->unsigned();
			$table->text('billing_address');
			$table->text('shipping_address');
			$table->string('billing_gst_tin', 15);
			$table->string('shipping_gst_tin', 15);
			$table->text('note')->nullable();
			$table->mediumText('term_and_conditions')->nullable();
			$table->timestamp('created_on');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}