<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('title');
			$table->longText('description');
			$table->enum('priority', array('Normal', 'High', 'Low', 'Highest'));
			$table->string('comment');
			$table->enum('status', array('Pending', 'InProgress', 'Done'));
			$table->integer('created_by')->unsigned();
			$table->integer('assigned_to')->unsigned();
			$table->integer('component_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}