<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserActivityTable extends Migration {

	public function up()
	{
		Schema::create('user_activity', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('covered_dist', 30)->nullable();
			$table->string('activity_image', 500)->nullable();
			$table->integer('category_id')->unsigned();
			$table->timestamp('start_time')->nullable();
			$table->timestamp('end_time')->nullable();
			$table->tinyInteger('is_verified')->nullable();
			$table->string('e_medal', 500)->nullable();
			$table->string('start_time_phto', 500)->nullable();
			$table->string('end_time_photo', 500)->nullable();
			$table->string('finisher_photo', 500)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_activity');
	}
}