<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 30)->nullable();
			$table->integer('age')->nullable();
			$table->string('email', 30)->unique()->nullable();
			$table->string('sex', 20)->nullable();
			$table->string('mobile', 30)->nullable();
			$table->string('address', 30)->nullable();
			$table->string('district', 20)->nullable();
			$table->string('state', 20)->nullable();
			$table->string('country', 20)->nullable();
			$table->string('password', 500);
			$table->string('image', 500)->nullable();
			$table->smallInteger('E-medal_status');
			$table->string('description', 30)->nullable();
			$table->smallInteger('status')->nullable();
			$table->string('otp', 500)->nullable();
			$table->datetime('otpSendTime')->nullable();
			$table->integer('otpFlag')->nullable();
			$table->integer('otp_Status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}