<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Offers', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('Brands')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Offers', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('Offers')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('Offers', function(Blueprint $table) {
			$table->dropForeign('Offers_brand_id_foreign');
		});
		Schema::table('Offers', function(Blueprint $table) {
			$table->dropForeign('Offers_category_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_offer_id_foreign');
		});
	}
}