<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Liquidacion extends Model 
{

    protected $table = 'liquidaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sede()
    {
        return $this->belongsTo('Sede', 'id');
    }

    public function documento()
    {
        return $this->belongsTo('Documento', 'id');
    }

    public function productos()
    {
        return $this->hasMany('LiquidacionProducto', 'liquidacion_id');
    }

    public function servicios()
    {
        return $this->hasMany('LiquidacionServicio', 'liquidacion_id');
    }

    public function paciente()
    {
        return $this->belongsTo('Paciente', 'id');
    }

}