<?php

namespace User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tercero()
    {
        return $this->belongsTo('Tercero', 'id');
    }

    public function roles()
    {
        return $this->hasMany('RolesUsuarios', 'user_id');
    }

}