<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EntityContent extends Model 
{

    protected $table = 'entity_contents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('entity_id', 'title', 'content', 'image', 'category_id');

    public function entity()
    {
        return $this->belongsTo('App\Entity');
    }

}