<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttributableAttributesTable extends Migration {

	public function up()
	{
		Schema::create('attributable_attributes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('attribute_type')->nullable();
			$table->integer('attribute_id')->unsigned()->nullable();
			$table->string('attribute_key', 100)->nullable();
			$table->string('attribute_value')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('attributable_attributes');
	}
}