<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityContentsTable extends Migration {

	public function up()
	{
		Schema::create('entity_contents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->string('title')->nullable();
			$table->text('content')->nullable();
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('entity_contents');
	}
}