<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id')->unsigned()->index();
			$table->string('title')->nullable();
			$table->text('content')->nullable();
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}