<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attribute extends Eloquent {

	protected $table = 'attributable_attributes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('attribute_type', 'attribute_id', 'attribute_key', 'attribute_value');

	public function attributable()
	{
		return $this->morphTo();
	}

}