<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description');

	public function users()
	{
		return $this->belongsToMany('App\User');
	}

	public function permissions()
	{
		return $this->belongsToMany('App\Permission');
	}

}