<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('entities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->nullable();
			$table->string('logo', 150)->nullable();
			$table->string('short_description', 500)->nullable();
			$table->text('description')->nullable();
			$table->json('socials')->nullable();
			$table->string('url')->nullable();
			$table->enum('type', array('accelerators', 'startups', 'investors'))->nullable();
			$table->json('images')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('entities');
	}
}