<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParametersTable extends Migration {

	public function up()
	{
		Schema::create('parameters', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned()->index()->default('null');
			$table->enum('type', array('text', 'textarea', 'dropdown', 'checkbox', 'radio', 'switch'));
			$table->boolean('is_required')->default(false);
			$table->integer('unit_id')->nullable()->index()->default('null');
			$table->text('validation_rules');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('parameters');
	}
}