<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('client_name', 299);
			$table->string('key_hash', 299)->nullable();
			$table->string('domain_name', 299);
			$table->text('url_authenticate');
			$table->string('prefix', 299)->nullable();
			$table->integer('currency_id')->unsigned();
			$table->double('deposit_limit', 50)->nullable();
			$table->double('withdraw_limit')->nullable();
			$table->integer('invoice_generation_date_id')->unsigned();
			$table->bigInteger('client_category_id')->unsigned();
			$table->tinyInteger('allow_print')->default('1');
			$table->integer('maximum_downline');
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}