<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperatorsTable extends Migration {

	public function up()
	{
		Schema::create('operators', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('client_id')->unsigned();
			$table->integer('level')->nullable()->default('0');
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('operators');
	}
}