<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 299);
			$table->string('display_name', 299);
			$table->text('description');
			$table->tinyInteger('visibility_status')->default('1');
			$table->integer('module_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}