<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCombosTable extends Migration {

	public function up()
	{
		Schema::create('combos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->text('description')->nullable();
			$table->double('price', 8,2);
			$table->string('tag')->nullable();
			$table->boolean('featured')->default(0);
			$table->boolean('available')->default(1);
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('combos');
	}
}