<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DoctorsModel extends Eloquent {

	protected $table = 'doctors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'subcategory_id', 'name', 'phone', 'address', 'latitude', 'longitude', 'description', 'profile_image', 'working_hours', 'avg_rating', 'status');
	protected $visible = array('category_id', 'subcategory_id', 'name', 'phone', 'address', 'latitude', 'longitude', 'description', 'profile_image', 'working_hours', 'avg_rating', 'status');

	public function reviews()
	{
		return $this->hasMany('App\DoctorsReviewModel', 'doctor_id');
	}

	public function category()
	{
		return $this->belongsTo('App\CategoriesModel', 'category_id');
	}

}