<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('accreditation_id')->references('id')->on('accreditations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('scope_rating_id')->references('id')->on('scope_ratings')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('episode_type_id')->references('id')->on('episode_types')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('event_realization_id')->references('id')->on('event_realizations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('challenge_id')->references('id')->on('challenges')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('event_realizations', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('accreditation_id')->references('id')->on('accreditations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->foreign('episode_type_id')->references('id')->on('episode_types')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('accreditation_id')->references('id')->on('accreditations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('episode_type_id')->references('id')->on('episode_types')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->foreign('involvement_id')->references('id')->on('involvement_types')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('keywords', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('keywords')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('attendance_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('keywords')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('attendance_keyword', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('attendance_keyword', function(Blueprint $table) {
			$table->foreign('attendance_id')->references('id')->on('attendances')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('event_keyword', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('event_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('keywords')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('institution_category_id')->references('id')->on('institution_categories')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->foreign('responsible_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('episode_type_involvement', function(Blueprint $table) {
			$table->foreign('episode_type_id')->references('id')->on('episode_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('episode_type_involvement', function(Blueprint $table) {
			$table->foreign('involvement_type_id')->references('id')->on('involvement_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('event_involvement', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('event_involvement', function(Blueprint $table) {
			$table->foreign('involvement_type_id')->references('id')->on('involvement_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->foreign('challenge_id')->references('id')->on('challenges')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->foreign('event_realization_id')->references('id')->on('event_realizations')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('challenge_levels', function(Blueprint $table) {
			$table->foreign('challenge_id')->references('id')->on('challenges')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('accreditations', function(Blueprint $table) {
			$table->foreign('evaluator_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('challenge_keyword', function(Blueprint $table) {
			$table->foreign('challenge_id')->references('id')->on('challenges')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('challenge_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('keywords')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('quiz_keyword', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('quiz_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('quizes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('institution_id')->references('id')->on('institutions')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('episode_type_id')->references('id')->on('episode_types')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('involvement_id')->references('id')->on('involvement_types')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('activity_keyword', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('activity_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_institution_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_user_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_accreditation_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_scope_rating_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_episode_type_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_quiz_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_student_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_event_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_event_realization_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_challenge_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_quiz_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_activity_id_foreign');
		});
		Schema::table('event_realizations', function(Blueprint $table) {
			$table->dropForeign('event_realizations_event_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_institution_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_user_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_accreditation_id_foreign');
		});
		Schema::table('challenges', function(Blueprint $table) {
			$table->dropForeign('challenges_episode_type_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_institution_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_user_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_accreditation_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_episode_type_id_foreign');
		});
		Schema::table('quizes', function(Blueprint $table) {
			$table->dropForeign('quizes_involvement_id_foreign');
		});
		Schema::table('keywords', function(Blueprint $table) {
			$table->dropForeign('keywords_parent_id_foreign');
		});
		Schema::table('attendance_keyword', function(Blueprint $table) {
			$table->dropForeign('attendance_keyword_keyword_id_foreign');
		});
		Schema::table('attendance_keyword', function(Blueprint $table) {
			$table->dropForeign('attendance_keyword_student_id_foreign');
		});
		Schema::table('attendance_keyword', function(Blueprint $table) {
			$table->dropForeign('attendance_keyword_attendance_id_foreign');
		});
		Schema::table('event_keyword', function(Blueprint $table) {
			$table->dropForeign('event_keyword_event_id_foreign');
		});
		Schema::table('event_keyword', function(Blueprint $table) {
			$table->dropForeign('event_keyword_keyword_id_foreign');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_institution_category_id_foreign');
		});
		Schema::table('institutions', function(Blueprint $table) {
			$table->dropForeign('institutions_responsible_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_institution_id_foreign');
		});
		Schema::table('episode_type_involvement', function(Blueprint $table) {
			$table->dropForeign('episode_type_involvement_episode_type_id_foreign');
		});
		Schema::table('episode_type_involvement', function(Blueprint $table) {
			$table->dropForeign('episode_type_involvement_involvement_type_id_foreign');
		});
		Schema::table('event_involvement', function(Blueprint $table) {
			$table->dropForeign('event_involvement_event_id_foreign');
		});
		Schema::table('event_involvement', function(Blueprint $table) {
			$table->dropForeign('event_involvement_involvement_type_id_foreign');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->dropForeign('challenge_elements_challenge_id_foreign');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->dropForeign('challenge_elements_event_realization_id_foreign');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->dropForeign('challenge_elements_quiz_id_foreign');
		});
		Schema::table('challenge_elements', function(Blueprint $table) {
			$table->dropForeign('challenge_elements_activity_id_foreign');
		});
		Schema::table('challenge_levels', function(Blueprint $table) {
			$table->dropForeign('challenge_levels_challenge_id_foreign');
		});
		Schema::table('accreditations', function(Blueprint $table) {
			$table->dropForeign('accreditations_evaluator_id_foreign');
		});
		Schema::table('challenge_keyword', function(Blueprint $table) {
			$table->dropForeign('challenge_keyword_challenge_id_foreign');
		});
		Schema::table('challenge_keyword', function(Blueprint $table) {
			$table->dropForeign('challenge_keyword_keyword_id_foreign');
		});
		Schema::table('quiz_keyword', function(Blueprint $table) {
			$table->dropForeign('quiz_keyword_quiz_id_foreign');
		});
		Schema::table('quiz_keyword', function(Blueprint $table) {
			$table->dropForeign('quiz_keyword_keyword_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_institution_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_user_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_episode_type_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_involvement_id_foreign');
		});
		Schema::table('activity_keyword', function(Blueprint $table) {
			$table->dropForeign('activity_keyword_activity_id_foreign');
		});
		Schema::table('activity_keyword', function(Blueprint $table) {
			$table->dropForeign('activity_keyword_keyword_id_foreign');
		});
	}
}