<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->string('email')->unique();
			$table->string('password');
			$table->text('subscription');
			$table->enum('state', array('enabled', 'disabled'));
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}